/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.util;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.OUIData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;

public class DBUtils
implements VerificationConstants {
    private static MessageBundle m_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle m_prvfMsgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static String[] m_srvctlEnv = new String[]{"CSS_CLUSTERNAME", "ORA_CSS_VARS", "ORA_ENVIRON_OPTS", "HAS_DEVELOPMENT_ENVIRONMENT", "OCR_DEVELOPER_ENV", "OLR_LOC"};
    Version m_crsVer = null;

    public DBUtils(Version crsVer) {
        this.m_crsVer = crsVer;
    }

    public String[] getDatabases() throws DBUtilsException {
        String[] cmdOutput = null;
        cmdOutput = Version.isPre112((Version)this.m_crsVer) ? this.runCrsStat(null) : this.runCrsctlStatus(null);
        ArrayList<String> dbLst = new ArrayList<String>();
        for (int i = 0; i < cmdOutput.length; ++i) {
            String[] prop = cmdOutput[i].split("=");
            Trace.out((String)("output line: " + cmdOutput[i]));
            if (prop.length != 2 || !prop[0].equals("NAME")) continue;
            String[] vals = prop[1].split("\\.");
            Trace.out((String)("vals.length = " + vals.length));
            if (vals.length != 3 || !vals[0].equals("ora") || !vals[2].equals("db")) continue;
            Trace.out((String)("adding " + vals[1] + " to db list"));
            dbLst.add(vals[1]);
        }
        if (dbLst.size() == 0) {
            Trace.out((String)"No databases were found. Returning zero length array");
        }
        return dbLst.toArray(new String[0]);
    }

    public Map<String, Vector> getRACHomesFromInventory() throws DBUtilsException {
        OiiiInstallInventory inv = null;
        OiicStandardInventorySession session = null;
        String applicationName = "oracle.server";
        HashMap<String, Vector> oracleHomes = new HashMap<String, Vector>();
        try {
            if (!OiiiInstallAreaControl.isCleanMachine()) {
                session = new OiicStandardInventorySession(applicationName, this.m_crsVer.toString());
                session.initSession(2);
                inv = session.getInstallAreaControl().getInstallInventory();
            }
            if (inv != null) {
                Vector homes = inv.getHomes();
                for (int i = 0; i < homes.size(); ++i) {
                    OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)homes.elementAt(i);
                    OiiiInstallCompInvEntry installCompInv = inv.findCompInRange(homeInfo.getIndex(), applicationName, "0.0.0.0.0", "999.999.999.999.999");
                    if (installCompInv == null || homeInfo.getNodeList() == null || homeInfo.getNodeList().size() <= 0) continue;
                    oracleHomes.put(homeInfo.getLocation(), homeInfo.getNodeList());
                }
            }
        }
        catch (OiitTargetLockNotAvailableException e) {
            throw new DBUtilsException(e);
        }
        catch (IOException e) {
            throw new DBUtilsException(e);
        }
        catch (OiiiInventoryDoesNotExistException e) {
            throw new DBUtilsException(e);
        }
        return oracleHomes;
    }

    public String getConnectDescriptor(String dbUniqueName) throws DBUtilsException {
        if (dbUniqueName == null) {
            Trace.out((String)"dbUniqueName is null. returning null");
            return null;
        }
        if (Version.isPre112((Version)this.m_crsVer)) {
            Trace.out((String)("use getConnectDescriptor with port in pre 11gR2 crs. m_crsVer is " + this.m_crsVer.toString()));
            throw new DBUtilsException(m_prvgMsgBundle, "11000", new Object[0]);
        }
        Trace.out((String)"Trying to get SCAN name and SCAN listener port");
        String[] scanInfo = this.getScanAndPort();
        Trace.out((String)"Trying to get database info");
        DatabaseInfo dbInfo = this.getDatabaseInfo(dbUniqueName);
        StringBuilder conctDescpr = new StringBuilder();
        conctDescpr.append("(DESCRIPTION = (LOAD_BALANCE=on)  (ADDRESS = (PROTOCOL = TCP)(HOST = ");
        conctDescpr.append(scanInfo[0]);
        conctDescpr.append(")(PORT = ");
        conctDescpr.append(scanInfo[1]);
        conctDescpr.append(")) (CONNECT_DATA =(SERVER = DEDICATED)(SERVICE_NAME = ");
        conctDescpr.append(dbInfo.getDefaultServiceName());
        conctDescpr.append(")))");
        return conctDescpr.toString();
    }

    public String getConnectDescriptor(String dbUniqueName, int port) throws DBUtilsException {
        if (dbUniqueName == null) {
            Trace.out((String)"dbUniqueName is null. returning null");
            return null;
        }
        DatabaseInfo dbInfo = this.getDatabaseInfo(dbUniqueName);
        List<String> nodeVips = this.getNodeVipsPre112(dbUniqueName);
        StringBuilder conctDescpr = new StringBuilder();
        conctDescpr.append("(DESCRIPTION= (SOURCE_ROUTE=yes) (ADDRESS_LIST= (FAILOVER=on) (LOAD_BALANCE=off)");
        for (int i = 0; i < nodeVips.size(); ++i) {
            conctDescpr.append("(ADDRESS= (PROTOCOL=tcp) (HOST=");
            conctDescpr.append(nodeVips.get(i));
            conctDescpr.append(") (PORT=");
            conctDescpr.append(port);
            conctDescpr.append("))");
        }
        conctDescpr.append(')');
        conctDescpr.append("(CONNECT_DATA=(SERVICE_NAME=");
        conctDescpr.append(dbInfo.getDefaultServiceName());
        conctDescpr.append("))");
        conctDescpr.append(')');
        Trace.out((String)("ConnectDescriptor for db " + dbUniqueName + " using port " + port + " is :" + conctDescpr));
        return conctDescpr.toString();
    }

    public DatabaseInfo getDatabaseInfo(String dbUniqueName) throws DBUtilsException {
        if (dbUniqueName == null) {
            Trace.out((String)"dbUniqueName is null. returning null");
            return null;
        }
        if (Version.isPre112((Version)this.m_crsVer)) {
            Trace.out((String)"Trying to get databases in pre 112 clusterware");
            return this.getDatabaseInfoPre112(dbUniqueName);
        }
        Trace.out((String)"Trying to get databases in 112 or latter clusterware");
        return this.getDatabaseInfo112(dbUniqueName);
    }

    public boolean isPortRequiredForConnect(String dbUniqueName) throws DBUtilsException {
        if (Version.isPre112((Version)this.m_crsVer)) {
            return true;
        }
        DatabaseInfo dbInfo = this.getDatabaseInfo(dbUniqueName);
        return Version.isPre112((Version)dbInfo.getVersion());
    }

    private DatabaseInfo getDatabaseInfoPre112(String dbUniqueName) throws DBUtilsException {
        return this.getDatabaseInfoPre112(null, dbUniqueName);
    }

    private DatabaseInfo getDatabaseInfoPre112(String crsHome, String dbUniqueName) throws DBUtilsException {
        Trace.out((String)("Trying to get Database info. dbUniqueName: " + dbUniqueName + " CRS Version:" + this.m_crsVer.toString()));
        String[] args = new String[]{"config", "database", "-d", dbUniqueName, "-a"};
        String dbDomain = null;
        String dbHome = null;
        Version dbVersion = null;
        String[] output = null;
        try {
            if (crsHome == null) {
                output = this.runSrvctl(args);
            } else {
                String[] env = new String[]{"ORACLE_HOME=" + crsHome, "NLS_LANG=American_America.US7ASCII"};
                output = this.runSrvctl(crsHome, env, args);
            }
        }
        catch (DBUtilsException dbe) {
            Trace.out((Exception)dbe);
            Trace.out((String)("DBUtilsException occured while running srvctl. message: " + dbe.getMessage()));
            throw new DBUtilsException(m_prvgMsgBundle, "11005", dbUniqueName);
        }
        for (int i = 0; i < output.length; ++i) {
            String[] prop = output[i].split(":");
            if (prop == null || prop.length != 2) continue;
            if (prop[0].equals("DOMAIN")) {
                dbDomain = prop[1].trim();
                Trace.out((String)("domain of " + dbUniqueName + " is " + dbDomain));
                if (!dbDomain.equals("null")) continue;
                Trace.out((String)"got dbDomain as 'null'");
                dbDomain = null;
                continue;
            }
            if (!prop[0].equals("ORACLE_HOME")) continue;
            dbHome = prop[1].trim();
            Trace.out((String)("home of " + dbUniqueName + " is " + dbHome));
        }
        if (dbHome == null) {
            Trace.out((String)("dbHome for database " + dbUniqueName + " is null. Throwing DBUtilsException..."));
            throw new DBUtilsException(m_prvgMsgBundle, "11005", dbUniqueName);
        }
        dbVersion = this.getDBVersion(dbHome);
        return new DatabaseInfo(dbUniqueName, dbDomain, dbVersion, dbHome);
    }

    private DatabaseInfo getDatabaseInfo112(String dbUniqueName) throws DBUtilsException {
        Trace.out((String)("Trying to get Database info. dbUniqueName: " + dbUniqueName + " CRS Version:" + this.m_crsVer.toString()));
        String[] args = new String[]{"ora." + dbUniqueName + ".db", "-p"};
        String dbDomain = null;
        String dbHome = null;
        Version dbVersion = null;
        Trace.out((String)("Trying to run crsctl to get Dababase info for database:" + dbUniqueName));
        String[] output = this.runCrsctlStatus(args);
        for (int i = 0; i < output.length; ++i) {
            String[] prop = output[i].split("=");
            if (prop == null || prop.length != 2) continue;
            if (prop[0].equals("USR_ORA_DOMAIN")) {
                dbDomain = prop[1].trim();
                Trace.out((String)("domain of " + dbUniqueName + " is " + dbDomain));
                continue;
            }
            if (!prop[0].equals("ORACLE_HOME")) continue;
            dbHome = prop[1].trim();
            Trace.out((String)("home of " + dbUniqueName + " is " + dbHome));
        }
        if (dbHome == null) {
            Trace.out((String)"dbHome is null. trying to run srvctl on each oracle home");
            OUIData oui = OUIData.getInstance();
            String[] oHomes = oui.getOracleHomeLocations();
            if (oHomes != null) {
                for (String oh : oHomes) {
                    try {
                        return this.getDatabaseInfoPre112(oh, dbUniqueName);
                    }
                    catch (DBUtilsException ex) {
                        Trace.out((String)ex.getMessage());
                    }
                }
            }
        }
        if (dbHome == null) {
            Trace.out((String)("dbHome for database " + dbUniqueName + " is null. Throwing DBUtilsException..."));
            throw new DBUtilsException(m_prvgMsgBundle, "11005", dbUniqueName);
        }
        dbVersion = this.getDBVersion(dbHome);
        return new DatabaseInfo(dbUniqueName, dbDomain, dbVersion, dbHome);
    }

    private String getDBHome(String dbUniqueName) throws DBUtilsException {
        OUIData oui = OUIData.getInstance();
        String[] oHomes = oui.getOracleHomeLocations();
        if (oHomes == null) {
            return null;
        }
        String[] args = new String[]{"config", "database"};
        String[] output = null;
        for (String oh : oHomes) {
            for (String dbName : output = this.runSrvctl(oh, null, args)) {
                if (!dbUniqueName.equals(dbName.trim())) continue;
                return oh;
            }
        }
        return null;
    }

    private List<String> getNodeVipsPre112(String dbUniqueName) throws DBUtilsException {
        String[] prop;
        int i;
        ArrayList<String> vipLst = new ArrayList<String>();
        ArrayList<String> nodeLst = new ArrayList<String>();
        List<String> instLst = this.getDBInstancesPre112(dbUniqueName);
        Trace.out((String)("Trying to get Nodes on which db, '" + dbUniqueName + "' is running"));
        String[] args = new String[instLst.size() + 1];
        args[0] = "-p";
        for (int i2 = 0; i2 < instLst.size(); ++i2) {
            args[i2 + 1] = "ora." + dbUniqueName + "." + instLst.get(i2) + ".inst";
        }
        String[] cmdOutput = this.runCrsStat(args);
        for (i = 0; i < cmdOutput.length; ++i) {
            prop = cmdOutput[i].split("=");
            Trace.out((String)("Finding Nodes: cmdOutput[" + i + "]=" + cmdOutput[i]));
            if (prop.length != 2 || !prop[0].equals("HOSTING_MEMBERS")) continue;
            Trace.out((String)("Finding Nodes: adding " + prop[1] + " to nodeLst"));
            nodeLst.add(prop[1]);
        }
        Trace.out((String)("Trying to get Node VIPs of nodes on which db, '" + dbUniqueName + "' is running"));
        if (Version.isPre112((Version)this.m_crsVer)) {
            args = new String[nodeLst.size() + 1];
            args[0] = "-p";
            for (i = 0; i < nodeLst.size(); ++i) {
                args[i + 1] = "ora." + (String)nodeLst.get(i) + ".vip";
            }
            cmdOutput = this.runCrsStat(args);
        } else {
            i = 0;
            args = new String[nodeLst.size() + 1];
            for (i = 0; i < nodeLst.size(); ++i) {
                args[i] = "ora." + (String)nodeLst.get(i) + ".vip";
            }
            args[i] = "-p";
            cmdOutput = this.runCrsctlStatus(args);
        }
        for (i = 0; i < cmdOutput.length; ++i) {
            prop = cmdOutput[i].split("=");
            Trace.out((String)("Finding Node VIPs: cmdOutput[" + i + "]=" + cmdOutput[i]));
            if (prop.length != 2 || !prop[0].equals("USR_ORA_VIP")) continue;
            Trace.out((String)("Finding Node VIPs: adding " + prop[1] + " to vipLst"));
            vipLst.add(prop[1]);
        }
        if (vipLst.size() == 0) {
            Trace.out((String)("node VIPs are not defined for the nodes on which database " + dbUniqueName + " is running. Throwing DBUtilsException..."));
            throw new DBUtilsException(m_prvgMsgBundle, "11006", dbUniqueName);
        }
        return vipLst;
    }

    private List<String> getDBInstancesPre112(String dbUniqueName) throws DBUtilsException {
        ArrayList<String> instLst = new ArrayList<String>();
        String[] cmdOutput = this.runCrsStat(null);
        if (cmdOutput != null) {
            for (int i = 0; i < cmdOutput.length; ++i) {
                String[] prop = cmdOutput[i].split("=");
                Trace.out((String)("cmdOutput[" + i + "]=" + cmdOutput[i]));
                if (prop.length != 2 || !prop[0].equals("NAME")) continue;
                String[] vals = prop[1].split("\\.");
                Trace.out((String)("vals.length = " + vals.length));
                if (vals.length != 4 || !vals[0].equals("ora") || !vals[1].equals(dbUniqueName) || !vals[3].equals("inst")) continue;
                Trace.out((String)("adding " + vals[2] + " inst list"));
                instLst.add(vals[2]);
            }
        }
        if (instLst.size() == 0) {
            Trace.out((String)("No instances are not defined for database " + dbUniqueName + "Throwing DBUtilsException..."));
            throw new DBUtilsException(m_prvgMsgBundle, "11007", dbUniqueName);
        }
        return instLst;
    }

    private String[] getScanAndPort() throws DBUtilsException {
        String[] prop;
        int i;
        String[] cmdOutput;
        String[] args;
        int scanOrdinalNum;
        String scanName = null;
        String portNum = null;
        Trace.out((String)"Tring to get SCAN name");
        for (scanOrdinalNum = 1; scanOrdinalNum < 4; ++scanOrdinalNum) {
            Trace.out((String)("Trying to query resource:ora.scan" + scanOrdinalNum + ".vip"));
            args = new String[]{"ora.scan" + scanOrdinalNum + ".vip", "-p"};
            cmdOutput = this.runCrsctlStatus(args);
            for (i = 0; i < cmdOutput.length; ++i) {
                prop = cmdOutput[i].split("=");
                Trace.out((String)("cmdOutput[" + i + "]=" + cmdOutput[i]));
                if (prop.length != 2 || !prop[0].equals("SCAN_NAME")) continue;
                scanName = prop[1];
                break;
            }
            if (scanName == null) continue;
            Trace.out((String)("got scan name: " + scanName));
            break;
        }
        if (scanName == null) {
            Trace.out((String)"SCAN is not defined. throwing DBUtilsException");
            new DBUtilsException(m_prvgMsgBundle, "11003", new Object[0]);
        }
        Trace.out((String)"Trying to get SCAN listener port");
        for (scanOrdinalNum = 1; scanOrdinalNum < 4; ++scanOrdinalNum) {
            Trace.out((String)("Trying to query resource:ora.LISTENER_SCAN" + scanOrdinalNum + ".lsnr"));
            args = new String[]{"ora.LISTENER_SCAN" + scanOrdinalNum + ".lsnr", "-p"};
            cmdOutput = this.runCrsctlStatus(args);
            for (i = 0; i < cmdOutput.length; ++i) {
                prop = cmdOutput[i].split("=");
                Trace.out((String)("cmdOutput[" + i + "]=" + cmdOutput[i]));
                if (prop.length != 2 || !prop[0].equals("PORT")) continue;
                portNum = prop[1];
                break;
            }
            if (portNum == null) continue;
            Trace.out((String)("got SCAN listener port number: " + portNum));
            break;
        }
        if (portNum == null) {
            Trace.out((String)"SCAN listener is not defined. throwing DBUtilsException");
            new DBUtilsException(m_prvgMsgBundle, "11004", new Object[0]);
        }
        return new String[]{scanName, portNum};
    }

    public Version getDBVersion(String dbHome) throws DBUtilsException {
        String[] env = new String[]{"ORACLE_HOME=" + dbHome, "NLS_LANG=American_America.US7ASCII"};
        String[] args = new String[]{"-V"};
        String[] cmdOutput = this.runSrvctl(dbHome, env, args);
        String dbVersion = null;
        for (int i = 0; i < cmdOutput.length; ++i) {
            Trace.out((String)("cmdOutput[" + i + "]=" + cmdOutput[i]));
            String[] prop = cmdOutput[i].split(":");
            if (prop.length != 2 || !prop[0].equals("srvctl version")) continue;
            dbVersion = prop[1].trim();
            Trace.out((String)("dbVersion found in dbHome " + dbHome + " is " + dbVersion));
            break;
        }
        try {
            return Version.getVersion(dbVersion);
        }
        catch (ConfigurationException cex) {
            throw new DBUtilsException(cex);
        }
    }

    public String[] getNodes(String dbUniqueName) throws DBUtilsException {
        String[] nodes = null;
        try {
            nodes = VerificationUtil.getStaticNodelist();
        }
        catch (NodelistNotFoundException ex) {
            throw new DBUtilsException(ex);
        }
        return nodes;
    }

    private String[] runCrsStat(String[] crsstatArgs) throws DBUtilsException {
        String crsHome = this.getCRSHome();
        String crs_stat = crsHome + FSEP + "bin" + FSEP + "crs_stat";
        String[] args = null;
        if (crsstatArgs == null) {
            args = new String[]{"-runexe", crs_stat};
        } else {
            args = new String[crsstatArgs.length + 2];
            args[0] = "-rungencmd";
            args[1] = crs_stat;
            System.arraycopy(crsstatArgs, 0, args, 2, crsstatArgs.length);
        }
        VerificationCommand[] cmds = new VerificationCommand[1];
        String localNode = null;
        try {
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhex) {
            throw new DBUtilsException(m_prvfMsgBundle, "0002", new Object[0]);
        }
        cmds[0] = new VerificationCommand(localNode, args, null);
        ResultSet rs = new ResultSet();
        Trace.out((String)("Trying to run " + crs_stat + " on node " + localNode));
        new GlobalHandler().submit((Command[])cmds, 0, rs);
        if (rs.allSuccess()) {
            String output = cmds[0].getOutput();
            return output.split(LSEP);
        }
        String cause = "";
        for (VerificationError vfe : rs.getErrors()) {
            String errMsg = vfe.getErrorMessage().replace("|", LSEP);
            cause = cause + LSEP + VerificationUtil.fetchVerificationValue(errMsg);
        }
        Trace.out((String)("Error message from crs_stat:" + cause));
        throw new DBUtilsException(cause, m_prvfMsgBundle, "11001", crs_stat, localNode);
    }

    private String[] runCrsctlStatus(String[] crsctlArgs) throws DBUtilsException {
        String crsHome = this.getCRSHome();
        String crsctl = crsHome + FSEP + "bin" + FSEP + "crsctl";
        String[] fixedArgs = new String[]{"-runexe", crsctl, "status", "resource"};
        String[] args = null;
        if (crsctlArgs == null) {
            args = fixedArgs;
        } else {
            args = new String[crsctlArgs.length + fixedArgs.length];
            System.arraycopy(fixedArgs, 0, args, 0, fixedArgs.length);
            System.arraycopy(crsctlArgs, 0, args, fixedArgs.length, crsctlArgs.length);
        }
        VerificationCommand[] cmds = new VerificationCommand[1];
        String localNode = null;
        try {
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhex) {
            throw new DBUtilsException(uhex, m_prvfMsgBundle, "0002", new Object[0]);
        }
        cmds[0] = new VerificationCommand(localNode, args, null);
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmds, 0, rs);
        if (rs.allSuccess()) {
            String output = cmds[0].getOutput();
            return output.split(LSEP);
        }
        String cause = "";
        for (VerificationError vfe : rs.getErrors()) {
            String errMsg = vfe.getErrorMessage().replace("|", LSEP);
            cause = cause + LSEP + VerificationUtil.fetchVerificationValue(errMsg);
        }
        Trace.out((String)("Error message from crsctl:" + cause));
        throw new DBUtilsException(cause, m_prvfMsgBundle, "5303", crsctl, localNode);
    }

    private String[] runSrvctl(String[] srvclArgs) throws DBUtilsException {
        String crsHome = this.getCRSHome();
        return this.runSrvctl(crsHome, null, srvclArgs);
    }

    private String[] runSrvctl(String crsHome, String[] env, String[] srvclArgs) throws DBUtilsException {
        String srvctl = crsHome + FSEP + "bin" + FSEP + "srvctl";
        String[] args = new String[srvclArgs.length + 2];
        args[0] = "-runexe";
        args[1] = srvctl;
        System.arraycopy(srvclArgs, 0, args, 2, srvclArgs.length);
        String localNode = null;
        try {
            Trace.out((String)"Trying to get local node");
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhex) {
            Trace.out((String)("Exception while getting local host. exception: " + uhex.getMessage()));
            throw new DBUtilsException(uhex, m_prvfMsgBundle, "0002", new Object[0]);
        }
        ArrayList<String> envList = new ArrayList<String>();
        if (env != null && Utils.isDevelopmentEnv()) {
            for (String envVar : m_srvctlEnv) {
                String envVal = System.getenv(envVar);
                if (!VerificationUtil.isStringGood(envVal)) continue;
                envList.add(envVar + "=" + envVal);
            }
            for (String e : env) {
                envList.add(e);
            }
            env = envList.toArray(new String[0]);
        }
        VerificationCommand[] cmds = new VerificationCommand[]{new VerificationCommand(localNode, args, env)};
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmds, 0, rs);
        if (rs.allSuccess() && cmds[0].getVfyCode() == 0) {
            return cmds[0].getOutput().split(LSEP);
        }
        String cause = "";
        if (rs.getErrors() != null && rs.getErrors().size() > 0) {
            boolean first = true;
            for (VerificationError vfe : rs.getErrors()) {
                String errMsg = vfe.getErrorMessage().replace("|", LSEP);
                if (first) {
                    first = false;
                } else {
                    cause = cause + LSEP;
                }
                cause = cause + errMsg;
            }
        } else {
            cause = cmds[0].getOutput();
        }
        Trace.out((String)("Error message from srvctl:" + cause));
        throw new DBUtilsException(cause, m_prvgMsgBundle, "11001", srvctl, localNode);
    }

    private String getCRSHome() throws DBUtilsException {
        String crsHome = VerificationUtil.getCRSHome(true);
        if (crsHome == null) {
            throw new DBUtilsException(m_prvfMsgBundle, "5301", new Object[0]);
        }
        return crsHome;
    }

    public String getDatabaseEnv(String crsHome, String dbUniqueName, String envVariableName) throws DBUtilsException {
        String[] env = new String[]{"ORACLE_HOME=" + crsHome, "NLS_LANG=American_America.US7ASCII"};
        String[] args = new String[]{"getenv", "database", "-d", dbUniqueName, "-t", envVariableName};
        String[] output = this.runSrvctl(crsHome, env, args);
        String val = null;
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                String[] prop = output[i].split("=");
                Trace.out((String)("output[" + i + "]=" + output[i]));
                if (prop.length != 2 || !prop[0].equals(envVariableName)) continue;
                val = prop[1];
            }
        }
        return val;
    }

    public static void main(String[] args) throws Exception {
        DBUtils u = new DBUtils(Version.getVersion((String)args[0]));
        String[] dbs = null;
        DatabaseInfo info = null;
        String desc = null;
        try {
            dbs = u.getDatabases();
            info = u.getDatabaseInfo(dbs[0]);
            desc = u.isPortRequiredForConnect(info.getUniqueName()) ? u.getConnectDescriptor(info.getUniqueName(), 1521) : u.getConnectDescriptor(info.getUniqueName());
            SQLFactory.main((String[])new String[]{desc, "scott", "tiger"});
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.out.println("database: " + dbs[0]);
        System.out.println("getDefaultServiceName: " + info.getDefaultServiceName());
        System.out.println("dbHome: " + info.getHome());
        System.out.println("dbVersion " + info.getVersion());
        System.out.println("Connect Descriptor: " + desc);
    }
}

